define([

		'app',
        'GoalGraphService',
		'LandingController',
		'InitialSettingsController',
	    'HomePageConstants',
        'WeeklyGoalsService',
        'SetGoalsModalController',
        'AbstractWeeklyGoalsService',
        'GoalGraphAccessibilityService',
        'GoalGraphService',
		'FitnessRemindersService',
		'AuthenticatedUserController',
		'UnauthenticatedUserController'


	],
	function (app) {
		'use strict';

		app.config(function ($stateProvider, $urlRouterProvider) {


			$urlRouterProvider.otherwise(function ($injector) {
				var $state = $injector.get('$state');
				$state.go('main.auth.home');
			});

			$stateProvider
				.state('main.auth.home', {
					url: '/home',
					appNavIndex: 1,
                    containerClass: 'home',
					data: {
						moduleName: 'Home'
					},
					views: {
						'@main': {
							templateUrl: 'src/container/components/content/single-column_template.html',
						},
						'primary@main.auth.home': {
							templateUrl: 'src/modules/home/landing/landing_template.html',
							controller: 'LandingController'
						}
					}
				})
				.state('main.initial-settings', {
					url: '/',
					views: {
						'@main': {
							templateUrl: 'src/container/components/content/single-column_template.html',
						},
						'primary@main.initial-settings': {
							templateUrl: 'src/modules/home/initial-settings/initial-settings_template.html',
							controller: 'InitialSettingsController'
						}
					},
					module: 'preventNavigation'
				});
		});
	});